#version 140
#extension GL_EXT_gpu_shader4 : enable
//Gyroid inside sphereMod01.fsh by rucksack
//https://www.shadertoy.com/view/7tscW4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// For easily pasting this into a project I'm working on
#define time iTime

// Raymarching parameters
#define MAX_STEPS 150
#define NEAR_ENOUGH 0.005
#define TOO_FAR 20.0

// Lighting parameters
#define DIFFUSE_FACTOR 0.6
#define SPECULAR_FACTOR .9
#define SHININESS 16.

#define BACKGROUND_COLOR vec3(0., 0., 0.)
#define SURFACE_COLOR vec3(0.76471,0.78039,0.78039)
#define BLOOM_COLOR vec3(0.84314,0.67843,0.39216)

// Parameters
#define SMOOTH_FACTOR 0.3
#define BLOOM_STEP 0.04

float sphere(vec3 point, vec3 center, float radius) {
    return length(point - center) - radius;
}

float distance_from_everything(vec3 point) {
    // sphere encapsulating gyroid
    float s = sphere(point, vec3(0, 0, 2.), 3.);
    float scale = 2.4;
    float bias = 0.;
    float thickness = .1;
    float a = .5*(cos(time)+2.);
    float b = .7*(sin(time) + 2.);
    point *= scale;
    // gyroid
    float d = (abs(dot(sin(point*a), cos(point.zxy*b)))-bias)/scale - thickness;
    d = max(d*.4, s);
    return d;
}

float ray_march(vec3 ray_origin, vec3 ray_direction) {
    // How far we've traveled
    float d = 0.0;
    for (int i = 0; i < MAX_STEPS; i++) {
        // Where we stand
        vec3 point = ray_origin + ray_direction*d;
        // How far anything is from us
        float current_distance = distance_from_everything(point);
        // March on
        d += current_distance*.6; // As suggested by elenzil
        // Check status - have we reached a surface?
        if (current_distance < NEAR_ENOUGH || d > TOO_FAR)
            break;
    }
    return d;
}

// See https://www.iquilezles.org/www/articles/normalsSDF/normalsSDF.htm
vec3 estimate_normal(vec3 point) {
    vec2 e = vec2(NEAR_ENOUGH, 0); // x smol, y none
    // Find normal as tangent of distance function
    return normalize(vec3(
        distance_from_everything(point + e.xyy) - distance_from_everything(point - e.xyy),
        distance_from_everything(point + e.yxy) - distance_from_everything(point - e.yxy),
        distance_from_everything(point + e.yyx) - distance_from_everything(point - e.yyx)
    ));
}

float phong_light(vec3 point, vec3 light_position, vec3 n, vec3 camera) {
    vec3 l = normalize(light_position-point);
    vec3 c = normalize(camera-point);
    // Standard diffuse term
    float diffuse = max(dot(n, l), 0.);
    float specular = pow(max(dot(reflect(-l, n), -c), 0.), SHININESS);

    return DIFFUSE_FACTOR * diffuse + SPECULAR_FACTOR * specular;
}

float bloom(vec3 ray_origin, vec3 ray_direction) {
    float bloom = 0.0;
    float stepdist = NEAR_ENOUGH;
    for (int i = 0; i < MAX_STEPS; i++) {
        vec3 point = ray_origin + ray_direction*stepdist;
        float nextdist = distance_from_everything(point);
        // Update bloom
        bloom += BLOOM_STEP;
        // March on
        stepdist += nextdist;
        // Continue even if we reach a surface
        if (stepdist > TOO_FAR)
            break;
    }
    // Stop bloom from exceeding 1
    return min(bloom, 1.);
}

vec3 lighting(vec3 point, vec3 camera, vec3 ray_direction, float dist) {
    // Avoid casting specular highlight from the void
    // (and blend in bloom)
    float bloom = bloom(camera, ray_direction);
    if (length(point - camera) > TOO_FAR*0.99)
        return BACKGROUND_COLOR + bloom * BLOOM_COLOR;

    float phong = phong_light(point, vec3(1, 1, -2), estimate_normal(point), camera);

    return phong * SURFACE_COLOR + .5*sqrt(bloom) * BLOOM_COLOR;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    vec2 xy = (gl_FragCoord.xy - 0.5*iResolution.xy) / iResolution.y;

    // Ray origin
    vec3 camera = vec3(0., 0, -4.);
    // Ray direction
    vec3 ray_direction = vec3(xy, 1.);

    float d = ray_march(camera, ray_direction);
    
    vec3 point = camera + ray_direction * d;
    
    vec3 base_color = lighting(point, camera, ray_direction, d);

    gl_FragColor = vec4(base_color, 1.);
}







